appModule.directive("rawHtml", ["notices", "api", "pages", "utils", function (notices, api, pages, utils) {
    return {
        restrict: "A",
        scope: {
            content: "=",
        },
        link: function ($scope, element) {
            var stopWatch = $scope.$watch("content", function (newV, oldV) {
                if (!!newV) {
                    $(element).html(newV);
                    $("a[href^='http://gnet-uc-native.quanshi.com?act=cloudFileDownload']").on("click", function (e) {
                        e.stopPropagation();
                        e.preventDefault();
                        notices.downloadCloudFile(this.href, function () {
                          utils.requestMainWindowMethod('uc.IUIService','changeModule',[8],function(){}); //UC.constants.UI.ModuleId.UploadDownloadList: 8
                        });
                        return false;
                    });
                    setTimeout(function () {
                        var medias = element.find('video, audio');
                        medias.each(function () {
                            this.addEventListener('canplay', function () {
                                log.logInfo('video can play ' + this.children[0].src);
                            });
                            this.addEventListener('stalled', function () {
                                log.logInfo('video stalled ' + this.children[0].src);
                            });
                            this.addEventListener('abort', function () {
                                log.logInfo('video abort ' + this.children[0].src);
                            });
                            this.addEventListener('play', function () {
                                //pause other playing video & audio
                                var that = this;
                                medias.each(function () {
                                    if (that != this) {
                                        this.pause();
                                    }
                                });
                            });
                        });
                    });
                } else {
                    $(element).empty();
                }
            });
            
            $scope.$on("$destroy", function () {
                stopWatch();
            });
        }
    };
}]);
